/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.BlobStoreInterface;
import com.mckoi.database.FixedRecordList;
import com.mckoi.database.StoreSystem;
import com.mckoi.database.global.BlobRef;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ClobRef;
import com.mckoi.database.global.Ref;
import com.mckoi.database.jdbc.AsciiReader;
import com.mckoi.database.jdbc.BinaryToUnicodeReader;
import com.mckoi.store.Area;
import com.mckoi.store.AreaWriter;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.PagedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

final class BlobStore
implements BlobStoreInterface {
    private static final int MAGIC = 314332073;
    private Store store;
    private FixedRecordList fixed_list;
    private long first_delete_chain_record;

    BlobStore(Store store) {
        this.store = store;
        this.fixed_list = new FixedRecordList(store, 24);
    }

    long create() throws IOException {
        long fixed_list_p = this.fixed_list.create();
        this.first_delete_chain_record = -1L;
        this.fixed_list.setReservedLong(-1L);
        AreaWriter blob_store_header = this.store.createArea(32L);
        long blob_store_p = blob_store_header.getID();
        blob_store_header.putInt(314332073);
        blob_store_header.putInt(1);
        blob_store_header.putLong(fixed_list_p);
        blob_store_header.finish();
        return blob_store_p;
    }

    void init(long blob_store_p) throws IOException {
        Area blob_store_header = this.store.getArea(blob_store_p);
        blob_store_header.position(0);
        int magic = blob_store_header.getInt();
        int version = blob_store_header.getInt();
        if (magic != 314332073) {
            throw new IOException("MAGIC value for BlobStore is not correct.");
        }
        if (version != 1) {
            throw new IOException("version number for BlobStore is not correct.");
        }
        long fixed_list_p = blob_store_header.getLong();
        this.fixed_list.init(fixed_list_p);
        this.first_delete_chain_record = this.fixed_list.getReservedLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyFrom(StoreSystem store_system, BlobStore src_blob_store) throws IOException {
        long node_count;
        FixedRecordList src_fixed_list;
        FixedRecordList fixedRecordList = src_fixed_list = src_blob_store.fixed_list;
        synchronized (fixedRecordList) {
            node_count = src_fixed_list.addressableNodeCount();
        }
        fixedRecordList = this.fixed_list;
        synchronized (fixedRecordList) {
            while (this.fixed_list.addressableNodeCount() < node_count) {
                this.fixed_list.increaseSize();
            }
            long last_deleted = -1L;
            int BLOCK_WRITE_COUNT = 1024;
            int max_to_read = (int)Math.min(1024L, node_count);
            long p = 0L;
            while (max_to_read > 0) {
                Object var39_34;
                int i;
                ArrayList<CopyBlobInfo> src_copy_list = new ArrayList<CopyBlobInfo>();
                FixedRecordList fixedRecordList2 = src_fixed_list;
                synchronized (fixedRecordList2) {
                    for (i = 0; i < max_to_read; ++i) {
                        MutableArea a = src_fixed_list.positionOnNode(p + (long)i);
                        int status = a.getInt();
                        if (status != 131072) {
                            CopyBlobInfo info = new CopyBlobInfo();
                            info.ref_count = a.getInt();
                            info.size = a.getLong();
                            info.ob_p = a.getLong();
                            src_copy_list.add(info);
                            continue;
                        }
                        src_copy_list.add(null);
                    }
                }
                try {
                    this.store.lockForWrite();
                    int sz = src_copy_list.size();
                    for (i = 0; i < sz; ++i) {
                        CopyBlobInfo info = (CopyBlobInfo)src_copy_list.get(i);
                        MutableArea a = this.fixed_list.positionOnNode(p + (long)i);
                        if (info == null) {
                            a.putInt(131072);
                            a.putInt(0);
                            a.putLong(-1L);
                            a.putLong(last_deleted);
                            a.checkOut();
                            last_deleted = p + (long)i;
                            continue;
                        }
                        Area src_blob_header = src_blob_store.store.getArea(info.ob_p);
                        int res = src_blob_header.getInt();
                        int type = src_blob_header.getInt();
                        long total_block_size = src_blob_header.getLong();
                        long total_block_pages = src_blob_header.getLong();
                        AreaWriter dst_blob_header = this.store.createArea(24L + total_block_pages * 8L);
                        long new_ob_header_p = dst_blob_header.getID();
                        dst_blob_header.putInt(res);
                        dst_blob_header.putInt(type);
                        dst_blob_header.putLong(total_block_size);
                        dst_blob_header.putLong(total_block_pages);
                        int n = 0;
                        while ((long)n < total_block_pages) {
                            long new_block_p;
                            long block_p = src_blob_header.getLong();
                            if (block_p != -1L) {
                                Area src_block = src_blob_store.store.getArea(block_p);
                                int block_type = src_block.getInt();
                                int block_size = src_block.getInt();
                                int new_block_size = block_size + 4 + 4;
                                AreaWriter dst_block_p = this.store.createArea(new_block_size);
                                new_block_p = dst_block_p.getID();
                                src_block.position(0);
                                src_block.copyTo(dst_block_p, new_block_size);
                                dst_block_p.finish();
                            } else {
                                new_block_p = -1L;
                            }
                            dst_blob_header.putLong(new_block_p);
                            ++n;
                        }
                        dst_blob_header.finish();
                        a.putInt(1);
                        a.putInt(0);
                        a.putLong(info.size);
                        a.putLong(new_ob_header_p);
                        a.checkOut();
                    }
                    var39_34 = null;
                    this.store.unlockForWrite();
                }
                catch (Throwable throwable) {
                    var39_34 = null;
                    this.store.unlockForWrite();
                    throw throwable;
                }
                p += (long)max_to_read;
                max_to_read = (int)Math.min(1024L, node_count -= (long)max_to_read);
                store_system.setCheckPoint();
            }
            this.first_delete_chain_record = last_deleted;
            this.fixed_list.setReservedLong(last_deleted);
        }
    }

    ClobRef putStringInBlobStore(String str) throws IOException {
        int BUF_SIZE = 65536;
        int size = str.length();
        byte type = 4;
        type = (byte)(type | 0x10);
        ClobRef ref = (ClobRef)this.allocateLargeObject(type, size * 2);
        byte[] buf = new byte[65536];
        long p = 0L;
        int str_i = 0;
        while (size > 0) {
            int to_write = Math.min(32768, size);
            int buf_i = 0;
            for (int i = 0; i < to_write; ++i) {
                char c = str.charAt(str_i);
                buf[buf_i] = (byte)(c >> 8);
                buf[++buf_i] = (byte)c;
                ++buf_i;
                ++str_i;
            }
            ref.write(p, buf, buf_i);
            size -= to_write;
            p += (long)(to_write * 2);
        }
        ref.complete();
        return ref;
    }

    BlobRef putByteLongObjectInBlobStore(ByteLongObject blob) throws IOException {
        int BUF_SIZE = 65536;
        byte[] src_buf = blob.getByteArray();
        int size = src_buf.length;
        BlobRef ref = (BlobRef)this.allocateLargeObject((byte)2, size);
        byte[] copy_buf = new byte[65536];
        int offset = 0;
        int to_write = Math.min(65536, size);
        while (to_write > 0) {
            System.arraycopy(src_buf, offset, copy_buf, 0, to_write);
            ref.write(offset, copy_buf, to_write);
            to_write = Math.min(65536, size - (offset += to_write));
        }
        ref.complete();
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addToRecordList(long record_p) throws IOException {
        FixedRecordList fixedRecordList = this.fixed_list;
        synchronized (fixedRecordList) {
            long next_chain;
            if (this.first_delete_chain_record == -1L) {
                this.fixed_list.increaseSize();
                int new_block_number = this.fixed_list.listBlockCount() - 1;
                long start_index = this.fixed_list.listBlockFirstPosition(new_block_number);
                long size_of_block = this.fixed_list.listBlockNodeCount(new_block_number);
                MutableArea a = this.fixed_list.positionOnNode(start_index);
                a.putInt(0);
                a.putInt(0);
                a.putLong(-1L);
                a.putLong(record_p);
                for (long n = 1L; n < size_of_block - 1L; ++n) {
                    a.putInt(131072);
                    a.putInt(0);
                    a.putLong(-1L);
                    a.putLong(start_index + n + 1L);
                }
                a.putInt(131072);
                a.putInt(0);
                a.putLong(-1L);
                a.putLong(-1L);
                a.checkOut();
                this.first_delete_chain_record = start_index + 1L;
                this.fixed_list.setReservedLong(this.first_delete_chain_record);
                return start_index;
            }
            long recycled_record = this.first_delete_chain_record;
            MutableArea block = this.fixed_list.positionOnNode(recycled_record);
            int rec_pos = block.position();
            int status = block.getInt();
            if ((status & 0x20000) == 0) {
                throw new Error("Assertion failed: record is not deleted!");
            }
            block.getInt();
            block.getLong();
            this.first_delete_chain_record = next_chain = block.getLong();
            this.fixed_list.setReservedLong(this.first_delete_chain_record);
            block.position(rec_pos);
            block.putInt(0);
            block.putInt(0);
            block.putLong(-1L);
            block.putLong(record_p);
            block.checkOut();
            return recycled_record;
        }
    }

    Ref allocateLargeObject(byte type, long size) throws IOException {
        block9: {
            byte st_type;
            long reference_id;
            block8: {
                block7: {
                    if (size < 0L) {
                        throw new IOException("Negative blob size not allowed.");
                    }
                    try {
                        this.store.lockForWrite();
                        long page_count = (size - 1L) / 65536L + 1L;
                        AreaWriter blob_area = this.store.createArea(page_count * 8L + 24L);
                        long blob_p = blob_area.getID();
                        blob_area.putInt(0);
                        blob_area.putInt(type);
                        blob_area.putLong(size);
                        blob_area.putLong(page_count);
                        for (long i = 0L; i < page_count; ++i) {
                            blob_area.putLong(-1L);
                        }
                        blob_area.finish();
                        reference_id = this.addToRecordList(blob_p);
                        st_type = (byte)(type & 0xF);
                        if (st_type != 2) break block7;
                        BlobRefImpl blobRefImpl = new BlobRefImpl(reference_id, type, size, true);
                        Object var14_11 = null;
                        this.store.unlockForWrite();
                        return blobRefImpl;
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        this.store.unlockForWrite();
                        throw throwable;
                    }
                }
                if (st_type != 3) break block8;
                ClobRefImpl clobRefImpl = new ClobRefImpl(reference_id, type, size, true);
                Object var14_12 = null;
                this.store.unlockForWrite();
                return clobRefImpl;
            }
            if (st_type != 4) break block9;
            ClobRefImpl clobRefImpl = new ClobRefImpl(reference_id, type, size, true);
            Object var14_13 = null;
            this.store.unlockForWrite();
            return clobRefImpl;
        }
        throw new IOException("Unknown large object type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getLargeObject(long reference_id) throws IOException {
        long blob_p;
        long size;
        FixedRecordList fixedRecordList = this.fixed_list;
        synchronized (fixedRecordList) {
            if (reference_id < 0L || reference_id >= this.fixed_list.addressableNodeCount()) {
                throw new IOException("reference_id is out of range.");
            }
            MutableArea block = this.fixed_list.positionOnNode(reference_id);
            int status = block.getInt();
            if ((status & 0x20000) != 0) {
                throw new Error("Assertion failed: record is deleted!");
            }
            int reference_count = block.getInt();
            size = block.getLong();
            blob_p = block.getLong();
        }
        Area blob_area = this.store.getArea(blob_p);
        blob_area.position(0);
        blob_area.getInt();
        byte type = (byte)blob_area.getInt();
        long block_size = blob_area.getLong();
        long page_count = blob_area.getLong();
        if (type == 2) {
            return new BlobRefImpl(reference_id, type, size, false);
        }
        return new ClobRefImpl(reference_id, type, size, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeBlob(AbstractRef ref) throws IOException {
        ref.assertIsOpen();
        long blob_reference_id = ref.getID();
        FixedRecordList fixedRecordList = this.fixed_list;
        synchronized (fixedRecordList) {
            MutableArea block = this.fixed_list.positionOnNode(blob_reference_id);
            int rec_pos = block.position();
            int status = block.getInt();
            if (status != 0) {
                throw new IOException("Assertion failed: record is not open.");
            }
            int reference_count = block.getInt();
            long size = block.getLong();
            long page_count = block.getLong();
            try {
                this.store.lockForWrite();
                block.position(rec_pos);
                block.putInt(1);
                block.putInt(0);
                block.putLong(ref.getRawSize());
                block.putLong(page_count);
                block.checkOut();
                Object var14_10 = null;
                this.store.unlockForWrite();
            }
            catch (Throwable throwable) {
                Object var14_11 = null;
                this.store.unlockForWrite();
                throw throwable;
            }
        }
        ref.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishReference(long blob_reference_id) {
        try {
            FixedRecordList fixedRecordList = this.fixed_list;
            synchronized (fixedRecordList) {
                MutableArea block = this.fixed_list.positionOnNode(blob_reference_id);
                int rec_pos = block.position();
                int status = block.getInt();
                if (status != 1) {
                    throw new RuntimeException("Assertion failed: record is not static.");
                }
                int reference_count = block.getInt();
                block.position(rec_pos + 4);
                block.putInt(reference_count + 1);
                block.checkOut();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReference(long blob_reference_id) {
        try {
            FixedRecordList fixedRecordList = this.fixed_list;
            synchronized (fixedRecordList) {
                MutableArea block = this.fixed_list.positionOnNode(blob_reference_id);
                int rec_pos = block.position();
                int status = block.getInt();
                if (status != 1) {
                    throw new RuntimeException("Assertion failed: Record is not static (status = " + status + ")");
                }
                int reference_count = block.getInt();
                if (reference_count == 0) {
                    throw new RuntimeException("Releasing when Blob reference counter is at 0.");
                }
                long object_size = block.getLong();
                long object_p = block.getLong();
                if (reference_count - 1 == 0) {
                    Area blob_area = this.store.getArea(object_p);
                    blob_area.getInt();
                    byte type = (byte)blob_area.getInt();
                    long total_size = blob_area.getLong();
                    long page_count = blob_area.getLong();
                    for (long i = 0L; i < page_count; ++i) {
                        long page_p = blob_area.getLong();
                        if (page_p <= 0L) continue;
                        this.store.deleteArea(page_p);
                    }
                    this.store.deleteArea(object_p);
                    block.position(rec_pos);
                    block.putInt(131072);
                    block.putInt(0);
                    block.putLong(-1L);
                    block.putLong(this.first_delete_chain_record);
                    block.checkOut();
                    this.first_delete_chain_record = blob_reference_id;
                    this.fixed_list.setReservedLong(this.first_delete_chain_record);
                } else {
                    block.position(rec_pos + 4);
                    block.putInt(reference_count - 1);
                    block.checkOut();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBlobByteArray(long reference_id, long offset, byte[] buf, int off, int length) throws IOException {
        long blob_p;
        long size;
        if (offset % 65536L != 0L) {
            throw new RuntimeException("Assert failed: offset is not 64k aligned.");
        }
        if (length > 65536) {
            throw new RuntimeException("Assert failed: length is greater than 64K.");
        }
        FixedRecordList fixedRecordList = this.fixed_list;
        synchronized (fixedRecordList) {
            if (reference_id < 0L || reference_id >= this.fixed_list.addressableNodeCount()) {
                throw new IOException("blob_reference_id is out of range.");
            }
            MutableArea block = this.fixed_list.positionOnNode(reference_id);
            int status = block.getInt();
            if ((status & 0x20000) != 0) {
                throw new Error("Assertion failed: record is deleted!");
            }
            int reference_count = block.getInt();
            size = block.getLong();
            blob_p = block.getLong();
        }
        if (offset < 0L || offset + (long)length > size) {
            throw new IOException("Blob invalid read.  offset = " + offset + ", length = " + length);
        }
        Area blob_area = this.store.getArea(blob_p);
        blob_area.getInt();
        byte type = (byte)blob_area.getInt();
        long page_number = offset / 65536L;
        blob_area.position((int)(page_number * 8L + 24L));
        long page_p = blob_area.getLong();
        Area page_area = this.store.getArea(page_p);
        page_area.position(0);
        int page_type = page_area.getInt();
        int page_size = page_area.getInt();
        if ((type & 0x10) != 0) {
            byte[] page_buf = new byte[page_size];
            page_area.get(page_buf, 0, page_size);
            Inflater inflater = new Inflater();
            inflater.setInput(page_buf, 0, page_size);
            try {
                int result_length = inflater.inflate(buf, off, length);
                if (result_length != length) {
                    throw new RuntimeException("Assert failed: decompressed length is incorrect.");
                }
            }
            catch (DataFormatException e) {
                throw new IOException("ZIP Data Format Error: " + e.getMessage());
            }
            inflater.end();
        } else {
            page_area.get(buf, off, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBlobByteArray(long reference_id, long offset, byte[] buf, int length) throws IOException {
        int write_length;
        byte[] to_write;
        long blob_p;
        long size;
        if (offset % 65536L != 0L) {
            throw new RuntimeException("Assert failed: offset is not 64k aligned.");
        }
        if (length > 65536) {
            throw new RuntimeException("Assert failed: length is greater than 64K.");
        }
        FixedRecordList fixedRecordList = this.fixed_list;
        synchronized (fixedRecordList) {
            if (reference_id < 0L || reference_id >= this.fixed_list.addressableNodeCount()) {
                throw new IOException("blob_reference_id is out of range.");
            }
            MutableArea block = this.fixed_list.positionOnNode(reference_id);
            int status = block.getInt();
            if ((status & 0x20000) != 0) {
                throw new Error("Assertion failed: record is deleted!");
            }
            int reference_count = block.getInt();
            size = block.getLong();
            blob_p = block.getLong();
        }
        MutableArea blob_area = this.store.getMutableArea(blob_p);
        blob_area.getInt();
        byte type = (byte)blob_area.getInt();
        size = blob_area.getLong();
        if (offset < 0L || offset + (long)length > size) {
            throw new IOException("Blob invalid write.  offset = " + offset + ", length = " + length + ", size = " + size);
        }
        long page_number = offset / 65536L;
        blob_area.position((int)(page_number * 8L + 24L));
        long page_p = blob_area.getLong();
        if (page_p != -1L) {
            throw new RuntimeException("Assert failed: page_p is not -1");
        }
        if ((type & 0x10) != 0) {
            Deflater deflater = new Deflater();
            deflater.setInput(buf, 0, length);
            deflater.finish();
            to_write = new byte[66560];
            write_length = deflater.deflate(to_write);
        } else {
            to_write = buf;
            write_length = length;
        }
        try {
            this.store.lockForWrite();
            AreaWriter page_area = this.store.createArea(write_length + 8);
            page_p = page_area.getID();
            page_area.putInt(1);
            page_area.putInt(write_length);
            page_area.put(to_write, 0, write_length);
            page_area.finish();
            blob_area.position((int)(page_number * 8L + 24L));
            blob_area.putLong(page_p);
            blob_area.checkOut();
            Object var23_18 = null;
            this.store.unlockForWrite();
        }
        catch (Throwable throwable) {
            Object var23_19 = null;
            this.store.unlockForWrite();
            throw throwable;
        }
    }

    private class BlobRefImpl
    extends AbstractRef
    implements BlobRef {
        BlobRefImpl(long reference_id, byte type, long size, boolean open_for_write) {
            super(reference_id, type, size, open_for_write);
        }

        public InputStream getInputStream() {
            return new BLOBInputStream(this.reference_id, this.size);
        }
    }

    private class ClobRefImpl
    extends AbstractRef
    implements ClobRef {
        ClobRefImpl(long reference_id, byte type, long size, boolean open_for_write) {
            super(reference_id, type, size, open_for_write);
        }

        public int length() {
            byte st_type = (byte)(this.type & 0xF);
            if (st_type == 3) {
                return (int)this.size;
            }
            if (st_type == 4) {
                return (int)(this.size / 2L);
            }
            throw new RuntimeException("Unknown type.");
        }

        public Reader getReader() {
            byte st_type = (byte)(this.type & 0xF);
            if (st_type == 3) {
                return new AsciiReader(new BLOBInputStream(this.reference_id, this.size));
            }
            if (st_type == 4) {
                return new BinaryToUnicodeReader(new BLOBInputStream(this.reference_id, this.size));
            }
            throw new RuntimeException("Unknown type.");
        }

        public String toString() {
            int BUF_SIZE = 8192;
            Reader r = this.getReader();
            StringBuffer buf = new StringBuffer(this.length());
            char[] c = new char[8192];
            try {
                while (true) {
                    int has_read;
                    if ((has_read = r.read(c, 0, 8192)) == 0 || has_read == -1) {
                        return new String(buf);
                    }
                    buf.append(c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("IO Error: " + e.getMessage());
            }
        }
    }

    private class AbstractRef {
        protected final long reference_id;
        protected final long size;
        protected final byte type;
        private boolean open_for_write;

        AbstractRef(long reference_id, byte type, long size, boolean open_for_write) {
            this.reference_id = reference_id;
            this.size = size;
            this.type = type;
            this.open_for_write = open_for_write;
        }

        void assertIsOpen() {
            if (!this.open_for_write) {
                throw new Error("Large object ref is newly allocated.");
            }
        }

        public long getRawSize() {
            return this.size;
        }

        void close() {
            this.open_for_write = false;
        }

        public int length() {
            return (int)this.size;
        }

        public long getID() {
            return this.reference_id;
        }

        public byte getType() {
            return this.type;
        }

        public void read(long offset, byte[] buf, int length) throws IOException {
            BlobStore.this.readBlobByteArray(this.reference_id, offset, buf, 0, length);
        }

        public void write(long offset, byte[] buf, int length) throws IOException {
            if (!this.open_for_write) {
                throw new IOException("Blob is read-only.");
            }
            BlobStore.this.writeBlobByteArray(this.reference_id, offset, buf, length);
        }

        public void complete() throws IOException {
            BlobStore.this.completeBlob(this);
        }
    }

    private class BLOBInputStream
    extends PagedInputStream {
        static final int B_SIZE = 65536;
        private long reference_id;

        public BLOBInputStream(long reference_id, long size) {
            super(65536, size);
            this.reference_id = reference_id;
        }

        public void readPageContent(byte[] buf, long pos, int length) throws IOException {
            BlobStore.this.readBlobByteArray(this.reference_id, pos, buf, 0, length);
        }
    }

    private static class CopyBlobInfo {
        int ref_count;
        long size;
        long ob_p;

        private CopyBlobInfo() {
        }
    }
}

